/*****************************************************************************
*  LPC154x SCT0 dithering demo program for LPCXpresso board
*
*  1. Use SCT0 timer to generate a 4 msec PWM output @ SCT0_OUT0
*  2. Duty cycle of the PWM signal starts with 25% (1msec ON, 3msec OFF)
*  3. SCT0_OUT0 is linked to P0_3 (green LED)
*  4. Pressing pushbutton SW2 (P1_9) will change the LED brightness to 37.5%
*     by using the SCT dithering feature (average of 1.5msec ON, 2.5msec OFF)
*  5. Release pushbutton SW2 will change the LED brightness back to 25%
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT0_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT0_Init(void)
{

	Chip_SCT_Init(LPC_SCT0);											                      // enable the SCT0 clock

	Chip_SCT_Config(LPC_SCT0, 	SCT_CONFIG_32BIT_COUNTER|
                              SCT_CONFIG_AUTOLIMIT_L 	);	            // unified timer and auto limit

	Chip_SCT_SetControl(LPC_SCT0, SCT_CTRL_PRE_L(1));					          // SCT0 clock input is 250KHZ/(249+1) = 1KHz (1msec)

	Chip_SCT_SetMatchCount(LPC_SCT0, SCT_MATCH_0, 3);					          // match 0 @ 4 msec
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_0, 3);

	Chip_SCT_SetMatchCount(LPC_SCT0, SCT_MATCH_1, 1);					          // match 1 @ 1 msec
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_1, 1);

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_0, ENABLE_ALL_STATES);		  // event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_0 , (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0 |
                                                                          SCT_COMBMODE_MATCH |
                                                                          SCT_STATELD_1      |
                                                                          SCT_STATEEV_0      ));	// match 0 condition only

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_1, ENABLE_ALL_STATES);		  // event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_1 , (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH1  |
                                                                          SCT_COMBMODE_MATCH  | 
                                                                          SCT_STATELD_1       |
                                                                          SCT_STATEEV_0       ));	 // match 1 condition only

	Chip_SCT_SetOutput(LPC_SCT0, SCT_OUTPUT_0 , SCT_EVT_0);				      // event 0 will set SCT0_OUT_0
	Chip_SCT_ClearOutput(LPC_SCT0, SCT_OUTPUT_0, SCT_EVT_1); 			      // event 1 will clear SCT0_OUT_0

	Chip_SCT_ClearControl(LPC_SCT0,SCT_CTRL_HALT_L);	   				        // unhalt it by clearing bit 2 of the CTRL register

}

int main(void)
{
	static uint8_t trg = 1;
  
   SystemCoreClockUpdate();
   Board_Init();


   	Chip_Clock_EnablePeriphClock(	(CHIP_SYSCTL_CLOCK_T) ( SYSCTL_CLOCK_SWM 	|
                                                          SYSCTL_CLOCK_GPIO1));				                  //enable SWM and GPIO port 1 clocks

   	Chip_SWM_MovablePinAssign(SWM_SCT0_OUT0_O,  3); 					      // P0_3 is SCT0_OUT0

    SCT0_Init();                                           				  // Initialize SCT0

    while (1)                                              				  // loop forever
    {
    	if (!Chip_GPIO_GetPinState(LPC_GPIO, 1,9) && trg)  				    // P1.9 (SW2) high to low?
        {
          trg = 0;														                      // trigger P1.9 low
          Chip_SCT_FractionalMatch(LPC_SCT0, SCT_FRAMATCH_1 , 15);  // use dithering (15 out of 16 cycles)
        }
    	else if (Chip_GPIO_GetPinState(LPC_GPIO, 1,9) && !trg)    		// P1.9 low to high?
        {
        	Chip_SCT_FractionalMatch(LPC_SCT0, SCT_FRAMATCH_1 , 0);   // dithering off                                   				// trigger P1.9 high
        	trg = 1;													                        // trigger P1.9 low
        }
    }
}
